/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package examples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.text.DateFormat;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class FileAttributes {

    public static void main(String[] args) {
        DosFileAttributes attrs = null;

        Path file = Paths.get("mydatasource");
        //Get the attribute of our file (assuming dos based files)
        try {
            attrs = Files.readAttributes(file, DosFileAttributes.class);
        } catch (IOException e) {
            System.out.println("Exception reading attributes of the file: " + e);
        }
        System.out.println(file);
        System.out.println("Creation time: " + attrs.creationTime());
        System.out.println("Last Modified: " + attrs.lastModifiedTime());
        System.out.println("Last Access:   " + attrs.lastAccessTime());
        if (!attrs.isDirectory()) {
            System.out.println("Size (K Bytes):" + (attrs.size() / 1024));
        }
        System.out.println("Archive: " + attrs.isArchive());
        System.out.println("Hidden: " + attrs.isHidden());
        System.out.println("ReadOnly: " + attrs.isReadOnly());
        System.out.println("System File: " + attrs.isSystem());
    }
}
